/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskManager;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class DelegateTaskCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String userId;

    public DelegateTaskCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        this.checkDelegateTask(task, commandContext);
        task.delegate(this.userId);
        task.triggerUpdateEvent();
        task.logUserOperation("Delegate");
        return null;
    }

    protected void checkDelegateTask(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskAssign(task);
        }
    }
}

