/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.ArrayList;

public class DeleteHistoricTaskInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public DeleteHistoricTaskInstanceCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        HistoricTaskInstanceEntity task = commandContext.getHistoricTaskInstanceManager().findHistoricTaskInstanceById(this.taskId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricTaskInstance(task);
        }
        this.writeUserOperationLog(commandContext, task);
        commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(this.taskId);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext, HistoricTaskInstanceEntity historicTask) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, 1));
        propertyChanges.add(new PropertyChange("async", null, false));
        commandContext.getOperationLogManager().logTaskOperations("DeleteHistory", historicTask, propertyChanges);
    }
}

