/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.core.model.CoreActivity;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.repository.ResourceDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class DeleteHistoricVariableInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String variableInstanceId;

    public DeleteHistoricVariableInstanceCmd(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "variableInstanceId", this.variableInstanceId);
        HistoricVariableInstanceEntity variable = commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstanceByVariableInstanceId(this.variableInstanceId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No historic variable instance found with id: " + this.variableInstanceId, "variable", (Object)variable);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricVariableInstance(variable);
        }
        commandContext.getHistoricDetailManager().deleteHistoricDetailsByVariableInstanceId(this.variableInstanceId);
        commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByVariableInstanceId(this.variableInstanceId);
        CoreActivity definition = null;
        try {
            if (variable.getProcessDefinitionId() != null) {
                definition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(variable.getProcessDefinitionId());
            } else if (variable.getCaseDefinitionId() != null) {
                definition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(variable.getCaseDefinitionId());
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        commandContext.getOperationLogManager().logHistoricVariableOperation("DeleteHistory", variable, (ResourceDefinitionEntity<?>)((Object)definition), new PropertyChange("name", null, variable.getName()));
        return null;
    }
}

