/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.CommentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.task.Comment;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class DeleteProcessInstanceCommentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String commentId;
    protected String processInstanceId;

    public DeleteProcessInstanceCommentCmd(String processInstanceId, String commentId) {
        this.processInstanceId = processInstanceId;
        this.commentId = commentId;
    }

    public DeleteProcessInstanceCommentCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processInstanceId", (Object)this.processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        EnsureUtil.ensureNotNull("No processInstance exists with processInstanceId: " + this.processInstanceId, "processInstance", (Object)processInstance);
        this.checkUpdateProcessInstanceById(this.processInstanceId, commandContext);
        if (this.commentId != null) {
            CommentEntity comment = commandContext.getCommentManager().findCommentByProcessInstanceIdAndCommentId(this.processInstanceId, this.commentId);
            if (comment != null) {
                commandContext.getDbEntityManager().delete(comment);
            }
        } else {
            List<Comment> comments = commandContext.getCommentManager().findCommentsByProcessInstanceId(this.processInstanceId);
            if (!comments.isEmpty()) {
                commandContext.getCommentManager().deleteCommentsByProcessInstanceIds(Collections.singletonList(this.processInstanceId));
            }
        }
        this.logOperation(processInstance, commandContext);
        return null;
    }

    protected void logOperation(ExecutionEntity processInstance, CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("comment", null, null);
        commandContext.getOperationLogManager().logCommentOperation("DeleteComment", processInstance, propertyChange);
    }

    protected void checkUpdateProcessInstanceById(String processInstanceId, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceById(processInstanceId);
        }
    }
}

