/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyManager;
import java.util.Collections;

public class DeletePropertyCmd
implements Command<Object> {
    protected String name;

    public DeletePropertyCmd(String name) {
        this.name = name;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkDeleteProperty);
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity propertyEntity = propertyManager.findPropertyById(this.name);
        if (propertyEntity != null) {
            propertyManager.delete(propertyEntity);
            commandContext.getOperationLogManager().logPropertyOperation("Delete", Collections.singletonList(new PropertyChange("name", null, this.name)));
        }
        return null;
    }
}

