/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteUserPictureCmd;
import io.openbpm.bpm.engine.impl.identity.IdentityOperationResult;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class DeleteUserCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    String userId;

    public DeleteUserCmd(String userId) {
        this.userId = userId;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("userId", (Object)this.userId);
        new DeleteUserPictureCmd(this.userId).execute(commandContext);
        commandContext.getIdentityInfoManager().deleteUserInfoByUserId(this.userId);
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().deleteUser(this.userId);
        commandContext.getOperationLogManager().logUserOperation(operationResult, this.userId);
        return null;
    }
}

