/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.model.bpmn.BpmnModelInstance;
import java.io.Serializable;

public class GetDeploymentBpmnModelInstanceCmd
implements Command<BpmnModelInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetDeploymentBpmnModelInstanceCmd(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.isEmpty()) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public BpmnModelInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
        BpmnModelInstance modelInstance = deploymentCache.findBpmnModelInstanceForProcessDefinition(this.processDefinitionId);
        EnsureUtil.ensureNotNull("no BPMN model instance found for process definition id " + this.processDefinitionId, "modelInstance", (Object)modelInstance);
        return modelInstance;
    }
}

