/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.exception.DeploymentResourceNotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ResourceEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;

public class GetDeploymentResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceName;

    public GetDeploymentResourceCmd(String deploymentId, String resourceName) {
        this.deploymentId = deploymentId;
        this.resourceName = resourceName;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)this.deploymentId);
        EnsureUtil.ensureNotNull("resourceName", (Object)this.resourceName);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadDeployment(this.deploymentId);
        }
        ResourceEntity resource = commandContext.getResourceManager().findResourceByDeploymentIdAndResourceName(this.deploymentId, this.resourceName);
        EnsureUtil.ensureNotNull(DeploymentResourceNotFoundException.class, "no resource found with name '" + this.resourceName + "' in deployment '" + this.deploymentId + "'", "resource", (Object)resource);
        return new ByteArrayInputStream(resource.getBytes());
    }
}

