/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetExecutionVariableCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String variableName;
    protected boolean isLocal;

    public GetExecutionVariableCmd(String executionId, String variableName, boolean isLocal) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("executionId", (Object)this.executionId);
        EnsureUtil.ensureNotNull("variableName", (Object)this.variableName);
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        EnsureUtil.ensureNotNull("execution " + this.executionId + " doesn't exist", "execution", (Object)execution);
        this.checkGetExecutionVariable(execution, commandContext);
        Object value = this.isLocal ? execution.getVariableLocal(this.variableName, true) : execution.getVariable(this.variableName, true);
        return value;
    }

    protected void checkGetExecutionVariable(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessInstanceVariable(execution);
        }
    }
}

