/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetExternalTaskErrorDetailsCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String externalTaskId;

    public GetExternalTaskErrorDetailsCmd(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull("No external task found with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessInstance(externalTask.getProcessInstanceId());
        }
        return externalTask.getErrorDetails();
    }
}

