/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.form.FormDefinition;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.task.TaskDefinition;

public class GetFormKeyCmd
implements Command<String> {
    protected String taskDefinitionKey;
    protected String processDefinitionId;

    public GetFormKeyCmd(String processDefinitionId) {
        this.setProcessDefinitionId(processDefinitionId);
    }

    public GetFormKeyCmd(String processDefinitionId, String taskDefinitionKey) {
        this.setProcessDefinitionId(processDefinitionId);
        if (taskDefinitionKey == null || taskDefinitionKey.isEmpty()) {
            throw new ProcessEngineException("The task definition key is mandatory, but '" + taskDefinitionKey + "' has been provided.");
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }

    protected void setProcessDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.isEmpty()) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
        Expression formKeyExpression = null;
        if (this.taskDefinitionKey == null) {
            FormDefinition formDefinition = processDefinition.getStartFormDefinition();
            formKeyExpression = formDefinition.getFormKey();
        } else {
            TaskDefinition taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
            formKeyExpression = taskDefinition.getFormKey();
        }
        String formKey = null;
        if (formKeyExpression != null) {
            formKey = formKeyExpression.getExpressionText();
        }
        return formKey;
    }
}

