/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;

    public GetJobExceptionStacktraceCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("jobId", (Object)this.jobId);
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        EnsureUtil.ensureNotNull("No job found with id " + this.jobId, "job", (Object)job);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadJob(job);
        }
        return job.getExceptionStacktrace();
    }
}

