/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.form.FormField;
import io.openbpm.bpm.engine.form.StartFormData;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.AbstractGetFormVariablesCmd;
import io.openbpm.bpm.engine.impl.cmd.GetStartFormCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.impl.VariableMapImpl;
import java.util.Collection;

public class GetStartFormVariablesCmd
extends AbstractGetFormVariablesCmd {
    private static final long serialVersionUID = 1L;

    public GetStartFormVariablesCmd(String resourceId, Collection<String> formVariableNames, boolean deserializeObjectValues) {
        super(resourceId, formVariableNames, deserializeObjectValues);
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        StartFormData startFormData = commandContext.runWithoutAuthorization(new GetStartFormCmd(this.resourceId));
        ProcessDefinition definition = startFormData.getProcessDefinition();
        this.checkGetStartFormVariables((ProcessDefinitionEntity)definition, commandContext);
        VariableMapImpl result = new VariableMapImpl();
        for (FormField formField : startFormData.getFormFields()) {
            if (this.formVariableNames != null && !this.formVariableNames.contains(formField.getId())) continue;
            result.put((Object)formField.getId(), (Object)this.createVariable(formField, null));
        }
        return result;
    }

    protected void checkGetStartFormVariables(ProcessDefinitionEntity definition, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(definition);
        }
    }
}

