/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.AttachmentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;

public class GetTaskAttachmentContentCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;
    protected String taskId;

    public GetTaskAttachmentContentCmd(String taskId, String attachmentId) {
        this.attachmentId = attachmentId;
        this.taskId = taskId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        AttachmentEntity attachment = (AttachmentEntity)commandContext.getAttachmentManager().findAttachmentByTaskIdAndAttachmentId(this.taskId, this.attachmentId);
        if (attachment == null) {
            return null;
        }
        String contentId = attachment.getContentId();
        if (contentId == null) {
            return null;
        }
        ByteArrayEntity byteArray = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, contentId);
        byte[] bytes = byteArray.getBytes();
        return new ByteArrayInputStream(bytes);
    }
}

