/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.form.FormField;
import io.openbpm.bpm.engine.form.TaskFormData;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.AbstractGetFormVariablesCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskManager;
import io.openbpm.bpm.engine.impl.task.TaskDefinition;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.impl.VariableMapImpl;
import java.util.Collection;

public class GetTaskFormVariablesCmd
extends AbstractGetFormVariablesCmd {
    private static final long serialVersionUID = 1L;

    public GetTaskFormVariablesCmd(String taskId, Collection<String> variableNames, boolean deserializeObjectValues) {
        super(taskId, variableNames, deserializeObjectValues);
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.resourceId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Cannot find task with id '" + this.resourceId + "'.", "task", (Object)task);
        this.checkGetTaskFormVariables(task, commandContext);
        VariableMapImpl result = new VariableMapImpl();
        TaskDefinition taskDefinition = task.getTaskDefinition();
        if (taskDefinition != null) {
            TaskFormData taskFormData = taskDefinition.getTaskFormHandler().createTaskForm(task);
            for (FormField formField : taskFormData.getFormFields()) {
                if (this.formVariableNames != null && !this.formVariableNames.contains(formField.getId())) continue;
                result.put(formField.getId(), (Object)this.createVariable(formField, task));
            }
        }
        task.collectVariables(result, this.formVariableNames, false, this.deserializeObjectValues);
        return result;
    }

    protected void checkGetTaskFormVariables(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTaskVariable(task);
        }
    }
}

