/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.identity.Picture;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetUserPictureCmd
implements Command<Picture>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public GetUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Picture execute(CommandContext commandContext) {
        String pictureByteArrayId;
        EnsureUtil.ensureNotNull("userId", (Object)this.userId);
        IdentityInfoEntity pictureInfo = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (pictureInfo != null && (pictureByteArrayId = pictureInfo.getValue()) != null) {
            ByteArrayEntity byteArray = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, pictureByteArrayId);
            return new Picture(byteArray.getBytes(), byteArray.getName());
        }
        return null;
    }
}

