/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.OptimisticLockingException;
import io.openbpm.bpm.engine.impl.cfg.TransactionContext;
import io.openbpm.bpm.engine.impl.cfg.TransactionState;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutor;
import io.openbpm.bpm.engine.impl.jobexecutor.MessageAddedNotification;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.util.ExceptionUtil;

public abstract class JobRetryCmd
implements Command<Object> {
    protected static final long serialVersionUID = 1L;
    protected String jobId;
    protected Throwable exception;

    protected JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    protected JobEntity getJob() {
        return Context.getCommandContext().getJobManager().findJobById(this.jobId);
    }

    protected void logException(JobEntity job) {
        if (this.exception != null) {
            job.setExceptionMessage(this.exception.getMessage());
            job.setExceptionStacktrace(this.getExceptionStacktrace());
        }
    }

    protected void decrementRetries(JobEntity job) {
        if (this.exception == null || this.shouldDecrementRetriesFor(this.exception)) {
            job.setRetries(job.getRetries() - 1);
        }
    }

    protected String getExceptionStacktrace() {
        return ExceptionUtil.getExceptionStacktrace(this.exception);
    }

    protected boolean shouldDecrementRetriesFor(Throwable t) {
        return !(t instanceof OptimisticLockingException);
    }

    protected void notifyAcquisition(CommandContext commandContext) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        MessageAddedNotification messageAddedNotification = new MessageAddedNotification(jobExecutor);
        TransactionContext transactionContext = commandContext.getTransactionContext();
        transactionContext.addTransactionListener(TransactionState.COMMITTED, messageAddedNotification);
    }
}

