/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class RegisterDeploymentCmd
implements Command<Void> {
    protected String deploymentId;

    public RegisterDeploymentCmd(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        DeploymentEntity deployment = commandContext.getDeploymentManager().findDeploymentById(this.deploymentId);
        EnsureUtil.ensureNotNull("Deployment " + this.deploymentId + " does not exist", "deployment", (Object)deployment);
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkRegisterDeployment);
        Context.getProcessEngineConfiguration().getRegisteredDeployments().add(this.deploymentId);
        return null;
    }
}

