/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.ProcessApplicationRegistration;
import io.openbpm.bpm.engine.impl.application.ProcessApplicationManager;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import java.util.Collections;
import java.util.Set;

public class RegisterProcessApplicationCmd
implements Command<ProcessApplicationRegistration> {
    protected ProcessApplicationReference reference;
    protected Set<String> deploymentsToRegister;

    public RegisterProcessApplicationCmd(String deploymentId, ProcessApplicationReference reference) {
        this(Collections.singleton(deploymentId), reference);
    }

    public RegisterProcessApplicationCmd(Set<String> deploymentsToRegister, ProcessApplicationReference appReference) {
        this.deploymentsToRegister = deploymentsToRegister;
        this.reference = appReference;
    }

    @Override
    public ProcessApplicationRegistration execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkRegisterProcessApplication);
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessApplicationManager processApplicationManager = processEngineConfiguration.getProcessApplicationManager();
        return processApplicationManager.registerProcessApplicationForDeployments(this.deploymentsToRegister, this.reference);
    }
}

