/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.Incident;
import java.util.Collections;

public class ResolveIncidentCmd
implements Command<Void> {
    protected String incidentId;

    public ResolveIncidentCmd(String incidentId) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "", "incidentId", (Object)incidentId);
        this.incidentId = incidentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        Incident incident = commandContext.getIncidentManager().findIncidentById(this.incidentId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find an incident with id '" + this.incidentId + "'", "incident", (Object)incident);
        if ("failedJob".equals(incident.getIncidentType()) || "failedExternalTask".equals(incident.getIncidentType())) {
            throw new BadUserRequestException("Cannot resolve an incident of type " + incident.getIncidentType());
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "", "executionId", (Object)incident.getExecutionId());
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(incident.getExecutionId());
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Cannot find an execution for an incident with id '" + this.incidentId + "'", "execution", (Object)execution);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstance(execution);
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation("Resolve", execution.getProcessInstanceId(), execution.getProcessDefinitionId(), null, Collections.singletonList(new PropertyChange("incidentId", null, this.incidentId)));
        execution.resolveIncident(this.incidentId);
        return null;
    }
}

