/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.identity.Tenant;
import io.openbpm.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import io.openbpm.bpm.engine.impl.identity.IdentityOperationResult;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class SaveTenantCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Tenant tenant;

    public SaveTenantCmd(Tenant tenant) {
        this.tenant = tenant;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("tenant", (Object)this.tenant);
        EnsureUtil.ensureWhitelistedResourceId(commandContext, "Tenant", this.tenant.getId());
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().saveTenant(this.tenant);
        commandContext.getOperationLogManager().logTenantOperation(operationResult, this.tenant.getId());
        return null;
    }
}

