/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.identity.User;
import io.openbpm.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import io.openbpm.bpm.engine.impl.identity.IdentityOperationResult;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.UserEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class SaveUserCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected User user;
    protected boolean skipPasswordPolicy;

    public SaveUserCmd(User user) {
        this(user, false);
    }

    public SaveUserCmd(User user, boolean skipPasswordPolicy) {
        this.user = user;
        this.skipPasswordPolicy = skipPasswordPolicy;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("user", (Object)this.user);
        EnsureUtil.ensureWhitelistedResourceId(commandContext, "User", this.user.getId());
        if (this.user instanceof UserEntity) {
            this.validateUserEntity(commandContext);
        }
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().saveUser(this.user);
        commandContext.getOperationLogManager().logUserOperation(operationResult, this.user.getId());
        return null;
    }

    private void validateUserEntity(CommandContext commandContext) {
        if (this.shouldCheckPasswordPolicy(commandContext) && !((UserEntity)this.user).checkPasswordAgainstPolicy()) {
            throw new ProcessEngineException("Password does not match policy");
        }
    }

    protected boolean shouldCheckPasswordPolicy(CommandContext commandContext) {
        return ((UserEntity)this.user).hasNewPassword() && !this.skipPasswordPolicy && commandContext.getProcessEngineConfiguration().isEnablePasswordPolicy();
    }
}

