/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.impl.batch.BatchElementConfiguration;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetExternalTaskRetriesCmd;
import io.openbpm.bpm.engine.impl.cmd.SetExternalTaskRetriesCmd;
import io.openbpm.bpm.engine.impl.cmd.UpdateExternalTaskRetriesBuilderImpl;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;

public class SetExternalTasksRetriesCmd
extends AbstractSetExternalTaskRetriesCmd<Void> {
    public SetExternalTasksRetriesCmd(UpdateExternalTaskRetriesBuilderImpl builder) {
        super(builder);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectExternalTaskIds(commandContext);
        List<String> collectedIds = elementConfiguration.getIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "externalTaskIds", collectedIds);
        int instanceCount = collectedIds.size();
        this.writeUserOperationLog(commandContext, instanceCount, false);
        int retries = this.builder.getRetries();
        for (String externalTaskId : collectedIds) {
            new SetExternalTaskRetriesCmd(externalTaskId, retries, false).execute(commandContext);
        }
        return null;
    }
}

