/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventProcessor;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.producer.HistoryEventProducer;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.IncidentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SetProcessDefinitionVersionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String processInstanceId;
    private final Integer processDefinitionVersion;

    public SetProcessDefinitionVersionCmd(String processInstanceId, Integer processDefinitionVersion) {
        EnsureUtil.ensureNotEmpty("The process instance id is mandatory", "processInstanceId", processInstanceId);
        EnsureUtil.ensureNotNull("The process definition version is mandatory", "processDefinitionVersion", (Object)processDefinitionVersion);
        EnsureUtil.ensurePositive("The process definition version must be positive", "processDefinitionVersion", (Long)processDefinitionVersion.longValue());
        this.processInstanceId = processInstanceId;
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition;
        ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        final ExecutionEntity processInstance = executionManager.findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ProcessEngineException("No process instance found for id = '" + this.processInstanceId + "'.");
        }
        if (!processInstance.isProcessInstanceExecution()) {
            throw new ProcessEngineException("A process instance id is required, but the provided id '" + this.processInstanceId + "' points to a child execution of process instance '" + processInstance.getProcessInstanceId() + "'. Please invoke the " + this.getClass().getSimpleName() + " with a root execution id.");
        }
        ProcessDefinitionEntity currentProcessDefinitionImpl = processInstance.getProcessDefinition();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        ProcessDefinitionEntity currentProcessDefinition = currentProcessDefinitionImpl instanceof ProcessDefinitionEntity ? (processDefinition = currentProcessDefinitionImpl) : deploymentCache.findDeployedProcessDefinitionById(currentProcessDefinitionImpl.getId());
        ProcessDefinitionEntity newProcessDefinition = deploymentCache.findDeployedProcessDefinitionByKeyVersionAndTenantId(currentProcessDefinition.getKey(), this.processDefinitionVersion, currentProcessDefinition.getTenantId());
        this.validateAndSwitchVersionOfExecution(commandContext, processInstance, newProcessDefinition);
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_UPDATE, processInstance)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createProcessInstanceUpdateEvt(processInstance);
                }
            });
        }
        List<ExecutionEntity> childExecutions = executionManager.findExecutionsByProcessInstanceId(this.processInstanceId);
        for (ExecutionEntity executionEntity : childExecutions) {
            this.validateAndSwitchVersionOfExecution(commandContext, executionEntity, newProcessDefinition);
        }
        List<JobEntity> jobs = commandContext.getJobManager().findJobsByProcessInstanceId(this.processInstanceId);
        List<JobDefinitionEntity> currentJobDefinitions = commandContext.getJobDefinitionManager().findByProcessDefinitionId(currentProcessDefinition.getId());
        List<JobDefinitionEntity> newVersionJobDefinitions = commandContext.getJobDefinitionManager().findByProcessDefinitionId(newProcessDefinition.getId());
        Map<String, String> jobDefinitionMapping = this.getJobDefinitionMapping(currentJobDefinitions, newVersionJobDefinitions);
        for (JobEntity jobEntity : jobs) {
            this.switchVersionOfJob(jobEntity, newProcessDefinition, jobDefinitionMapping);
        }
        List<IncidentEntity> incidents = commandContext.getIncidentManager().findIncidentsByProcessInstance(this.processInstanceId);
        for (IncidentEntity incidentEntity : incidents) {
            this.switchVersionOfIncident(commandContext, incidentEntity, newProcessDefinition);
        }
        PropertyChange propertyChange = new PropertyChange("processDefinitionVersion", currentProcessDefinition.getVersion(), this.processDefinitionVersion);
        commandContext.getOperationLogManager().logProcessInstanceOperation("ModifyProcessInstance", this.processInstanceId, null, null, Collections.singletonList(propertyChange));
        return null;
    }

    protected Map<String, String> getJobDefinitionMapping(List<JobDefinitionEntity> currentJobDefinitions, List<JobDefinitionEntity> newVersionJobDefinitions) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        block0: for (JobDefinitionEntity currentJobDefinition : currentJobDefinitions) {
            for (JobDefinitionEntity newJobDefinition : newVersionJobDefinitions) {
                if (!this.jobDefinitionsMatch(currentJobDefinition, newJobDefinition)) continue;
                mapping.put(currentJobDefinition.getId(), newJobDefinition.getId());
                continue block0;
            }
        }
        return mapping;
    }

    protected boolean jobDefinitionsMatch(JobDefinitionEntity currentJobDefinition, JobDefinitionEntity newJobDefinition) {
        boolean activitiesMatch = currentJobDefinition.getActivityId().equals(newJobDefinition.getActivityId());
        boolean typesMatch = Objects.equals(currentJobDefinition.getJobType(), newJobDefinition.getJobType());
        boolean configurationsMatch = Objects.equals(currentJobDefinition.getJobConfiguration(), newJobDefinition.getJobConfiguration());
        return activitiesMatch && typesMatch && configurationsMatch;
    }

    protected void switchVersionOfJob(JobEntity jobEntity, ProcessDefinitionEntity newProcessDefinition, Map<String, String> jobDefinitionMapping) {
        jobEntity.setProcessDefinitionId(newProcessDefinition.getId());
        jobEntity.setDeploymentId(newProcessDefinition.getDeploymentId());
        String newJobDefinitionId = jobDefinitionMapping.get(jobEntity.getJobDefinitionId());
        jobEntity.setJobDefinitionId(newJobDefinitionId);
    }

    protected void switchVersionOfIncident(CommandContext commandContext, IncidentEntity incidentEntity, ProcessDefinitionEntity newProcessDefinition) {
        incidentEntity.setProcessDefinitionId(newProcessDefinition.getId());
    }

    protected void validateAndSwitchVersionOfExecution(CommandContext commandContext, ExecutionEntity execution, ProcessDefinitionEntity newProcessDefinition) {
        if (execution.getActivity() != null) {
            String activityId = execution.getActivity().getId();
            ActivityImpl newActivity = newProcessDefinition.findActivity(activityId);
            if (newActivity == null) {
                throw new ProcessEngineException("The new process definition (key = '" + newProcessDefinition.getKey() + "') does not contain the current activity (id = '" + activityId + "') of the process instance (id = '" + this.processInstanceId + "').");
            }
            execution.setActivity(newActivity);
        }
        execution.setProcessDefinition(newProcessDefinition);
        List<TaskEntity> tasks = commandContext.getTaskManager().findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : tasks) {
            taskEntity.setProcessDefinitionId(newProcessDefinition.getId());
        }
    }
}

