/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyManager;
import java.util.Collections;

public class SetPropertyCmd
implements Command<Object> {
    protected String name;
    protected String value;

    public SetPropertyCmd(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkSetProperty);
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity property = propertyManager.findPropertyById(this.name);
        String operation = null;
        if (property != null) {
            property.setValue(this.value);
            operation = "Update";
        } else {
            property = new PropertyEntity(this.name, this.value);
            propertyManager.insert(property);
            operation = "Create";
        }
        commandContext.getOperationLogManager().logPropertyOperation(operation, Collections.singletonList(new PropertyChange("name", null, this.name)));
        return null;
    }
}

