/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetVariableCmd;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import io.openbpm.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Map;

public class SetTaskVariablesCmd
extends AbstractSetVariableCmd
implements VariableInstanceLifecycleListener<VariableInstanceEntity> {
    private static final long serialVersionUID = 1L;
    protected boolean taskLocalVariablesUpdated;

    public SetTaskVariablesCmd(String taskId, Map<String, ? extends Object> variables, boolean isLocal) {
        super(taskId, variables, isLocal);
    }

    @Override
    protected TaskEntity getEntity() {
        EnsureUtil.ensureNotNull("taskId", (Object)this.entityId);
        TaskEntity task = this.commandContext.getTaskManager().findTaskById(this.entityId);
        EnsureUtil.ensureNotNull("task " + this.entityId + " doesn't exist", "task", (Object)task);
        this.checkSetTaskVariables(task);
        task.addCustomLifecycleListener(this);
        return task;
    }

    @Override
    protected void onSuccess(AbstractVariableScope scope) {
        TaskEntity task = (TaskEntity)scope;
        if (this.taskLocalVariablesUpdated) {
            task.triggerUpdateEvent();
        }
        task.removeCustomLifecycleListener(this);
        super.onSuccess(scope);
    }

    @Override
    protected ExecutionEntity getContextExecution() {
        return this.getEntity().getExecution();
    }

    @Override
    protected void logVariableOperation(AbstractVariableScope scope) {
        TaskEntity task = (TaskEntity)scope;
        this.commandContext.getOperationLogManager().logVariableOperation(this.getLogEntryOperation(), null, task.getId(), PropertyChange.EMPTY_CHANGE);
    }

    protected void checkSetTaskVariables(TaskEntity task) {
        for (CommandChecker checker : this.commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateTaskVariable(task);
        }
    }

    protected void onLocalVariableChanged() {
        this.taskLocalVariablesUpdated = true;
    }

    @Override
    public void onCreate(VariableInstanceEntity variableInstance, AbstractVariableScope sourceScope) {
        this.onLocalVariableChanged();
    }

    @Override
    public void onDelete(VariableInstanceEntity variableInstance, AbstractVariableScope sourceScope) {
        this.onLocalVariableChanged();
    }

    @Override
    public void onUpdate(VariableInstanceEntity variableInstance, AbstractVariableScope sourceScope) {
        this.onLocalVariableChanged();
    }
}

