/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class UnlockJobCmd
implements Command<Void> {
    protected static final long serialVersionUID = 1L;
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected String jobId;

    public UnlockJobCmd(String jobId) {
        this.jobId = jobId;
    }

    protected JobEntity getJob() {
        return Context.getCommandContext().getJobManager().findJobById(this.jobId);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity job = this.getJob();
        if (Context.getJobExecutorContext() == null) {
            EnsureUtil.ensureNotNull("Job with id " + this.jobId + " does not exist", "job", (Object)job);
        } else if (Context.getJobExecutorContext() != null && job == null) {
            LOG.debugAcquiredJobNotFound(this.jobId);
            return null;
        }
        job.unlock();
        return null;
    }
}

