/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import java.util.Collections;
import java.util.Set;

public class UnregisterProcessApplicationCmd
implements Command<Void> {
    protected boolean removeProcessesFromCache;
    protected Set<String> deploymentIds;

    public UnregisterProcessApplicationCmd(String deploymentId, boolean removeProcessesFromCache) {
        this(Collections.singleton(deploymentId), removeProcessesFromCache);
    }

    public UnregisterProcessApplicationCmd(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        this.deploymentIds = deploymentIds;
        this.removeProcessesFromCache = removeProcessesFromCache;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentIds == null) {
            throw new ProcessEngineException("Deployment Ids cannot be null.");
        }
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkUnregisterProcessApplication);
        Context.getProcessEngineConfiguration().getProcessApplicationManager().unregisterProcessApplicationForDeployments(this.deploymentIds, this.removeProcessesFromCache);
        return null;
    }
}

