/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.impl.UpdateProcessInstancesSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.batch.BatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.BatchElementConfiguration;
import io.openbpm.bpm.engine.impl.batch.builder.BatchBuilder;
import io.openbpm.bpm.engine.impl.batch.update.UpdateProcessInstancesSuspendStateBatchConfiguration;
import io.openbpm.bpm.engine.impl.cmd.AbstractUpdateProcessInstancesSuspendStateCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class UpdateProcessInstancesSuspendStateBatchCmd
extends AbstractUpdateProcessInstancesSuspendStateCmd<Batch> {
    public UpdateProcessInstancesSuspendStateBatchCmd(CommandExecutor commandExecutor, UpdateProcessInstancesSuspensionStateBuilderImpl builder, boolean suspending) {
        super(commandExecutor, builder, suspending);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectProcessInstanceIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No process instance ids given", "process Instance Ids", elementConfiguration.getIds());
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Cannot be null.", "Process Instance ids", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("instance-update-suspension-state").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_UPDATE_PROCESS_INSTANCES_SUSPEND).operationLogHandler(this::writeUserOperationLogAsync).build();
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new UpdateProcessInstancesSuspendStateBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), this.suspending);
    }
}

