/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.impl.UpdateProcessInstancesSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.cmd.AbstractUpdateProcessInstancesSuspendStateCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.runtime.UpdateProcessInstanceSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;

public class UpdateProcessInstancesSuspendStateCmd
extends AbstractUpdateProcessInstancesSuspendStateCmd<Void> {
    public UpdateProcessInstancesSuspendStateCmd(CommandExecutor commandExecutor, UpdateProcessInstancesSuspensionStateBuilderImpl builder, boolean suspendstate) {
        super(commandExecutor, builder, suspendstate);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<String> processInstanceIds = this.collectProcessInstanceIds(commandContext).getIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No process instance ids given", "Process Instance ids", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Cannot be null.", "Process Instance ids", processInstanceIds);
        this.writeUserOperationLog(commandContext, processInstanceIds.size(), false);
        UpdateProcessInstanceSuspensionStateBuilderImpl suspensionStateBuilder = new UpdateProcessInstanceSuspensionStateBuilderImpl(this.commandExecutor);
        if (this.suspending) {
            for (String processInstanceId : processInstanceIds) {
                suspensionStateBuilder.byProcessInstanceId(processInstanceId).suspend();
            }
        } else {
            for (String processInstanceId : processInstanceIds) {
                suspensionStateBuilder.byProcessInstanceId(processInstanceId).activate();
            }
        }
        return null;
    }
}

