/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd.batch;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.ProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.batch.BatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.BatchElementConfiguration;
import io.openbpm.bpm.engine.impl.batch.builder.BatchBuilder;
import io.openbpm.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteProcessInstanceBatchCmd
implements Command<Batch> {
    protected final String deleteReason;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected boolean skipCustomListeners;
    protected boolean skipSubprocesses;
    protected boolean skipIoMappings;

    public DeleteProcessInstanceBatchCmd(List<String> processInstances, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason, boolean skipCustomListeners, boolean skipSubprocesses, boolean skipIoMappings) {
        this.processInstanceIds = processInstances;
        this.processInstanceQuery = processInstanceQuery;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.deleteReason = deleteReason;
        this.skipCustomListeners = skipCustomListeners;
        this.skipSubprocesses = skipSubprocesses;
        this.skipIoMappings = skipIoMappings;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectProcessInstanceIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("instance-deletion").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected BatchElementConfiguration collectProcessInstanceIds(CommandContext commandContext) {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQueryImpl;
        ProcessInstanceQueryImpl instanceQuery;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        List<String> instanceIds = this.getProcessInstanceIds();
        if (!CollectionUtil.isEmpty(instanceIds)) {
            ProcessInstanceQueryImpl query = new ProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(instanceIds));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings), instanceIds);
        }
        if ((instanceQuery = (ProcessInstanceQueryImpl)this.processInstanceQuery) != null) {
            elementConfiguration.addDeploymentMappings(instanceQuery.listDeploymentIdMappings());
        }
        if ((historicProcessInstanceQueryImpl = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            elementConfiguration.addDeploymentMappings(historicProcessInstanceQueryImpl.listDeploymentIdMappings());
        }
        return elementConfiguration;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", null, null, null, propertyChanges);
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new DeleteProcessInstanceBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), this.deleteReason, this.skipCustomListeners, this.skipSubprocesses, false, this.skipIoMappings);
    }
}

