/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.behavior;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmmn.CaseControlRule;
import io.openbpm.bpm.engine.impl.cmmn.behavior.CmmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.cmmn.behavior.PlanItemDefinitionActivityBehavior;
import io.openbpm.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import io.openbpm.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnActivity;

public abstract class StageOrTaskActivityBehavior
extends PlanItemDefinitionActivityBehavior {
    protected static final CmmnBehaviorLogger LOG = ProcessEngineLogger.CMNN_BEHAVIOR_LOGGER;
    private static final String TRANSITION_COMPLETE = "complete";
    private static final String TRANSITION_DISABLE = "disable";
    private static final String TRANSITION_ENABLE = "enable";
    private static final String TRANSITION_EXIT = "exit";
    private static final String TRANSITION_PARENT_RESUME = "parentResume";
    private static final String TRANSITION_PARENT_SUSPEND = "parentSuspend";
    private static final String TRANSITION_PARENT_SUSPENSION = "parentSuspension";
    private static final String TRANSITION_PARENT_TERMINATE = "parentTerminate";
    private static final String TRANSITION_RESUME = "resume";
    private static final String TRANSITION_RE_ENABLE = "re-enable";
    private static final String TRANSITION_START = "start";
    private static final String TRANSITION_SUSPEND = "suspend";
    private static final String TRANSITION_TERMINATE = "terminate";
    private static final String TRANSITION_MANUAL_START = "manualStart";

    @Override
    protected void creating(CmmnActivityExecution execution) {
        this.evaluateRequiredRule(execution);
    }

    @Override
    public void created(CmmnActivityExecution execution) {
        if (execution.isAvailable() && this.isAtLeastOneEntryCriterionSatisfied(execution)) {
            this.fireEntryCriteria(execution);
        }
    }

    @Override
    public void onEnable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_ENABLE);
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.ENABLED, TRANSITION_ENABLE);
    }

    @Override
    public void onReenable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_RE_ENABLE);
        this.ensureTransitionAllowed(execution, CaseExecutionState.DISABLED, CaseExecutionState.ENABLED, TRANSITION_RE_ENABLE);
    }

    @Override
    public void onDisable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_DISABLE);
        this.ensureTransitionAllowed(execution, CaseExecutionState.ENABLED, CaseExecutionState.DISABLED, TRANSITION_DISABLE);
    }

    @Override
    public void onStart(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_START);
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.ACTIVE, TRANSITION_START);
    }

    @Override
    public void onManualStart(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_MANUAL_START);
        this.ensureTransitionAllowed(execution, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE, TRANSITION_START);
    }

    @Override
    public void started(CmmnActivityExecution execution) {
        if (execution.isActive()) {
            this.performStart(execution);
        }
    }

    protected abstract void performStart(CmmnActivityExecution var1);

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, TRANSITION_COMPLETE);
        this.completing(execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, TRANSITION_COMPLETE);
        this.manualCompleting(execution);
    }

    @Override
    public void onTermination(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.TERMINATED, TRANSITION_TERMINATE);
        this.performTerminate(execution);
    }

    @Override
    public void onParentTermination(CmmnActivityExecution execution) {
        String id = execution.getId();
        throw LOG.illegalStateTransitionException(TRANSITION_PARENT_TERMINATE, id, this.getTypeName());
    }

    @Override
    public void onExit(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isTerminated()) {
            throw LOG.alreadyTerminatedException(TRANSITION_EXIT, id);
        }
        if (execution.isCompleted()) {
            throw LOG.wrongCaseStateException(TRANSITION_EXIT, id, "[available|enabled|disabled|active|failed|suspended]", "completed");
        }
        this.performExit(execution);
    }

    @Override
    public void onSuspension(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.SUSPENDED, TRANSITION_SUSPEND);
        this.performSuspension(execution);
    }

    @Override
    public void onParentSuspension(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_PARENT_SUSPENSION);
        String id = execution.getId();
        if (execution.isSuspended()) {
            throw LOG.alreadySuspendedException(TRANSITION_PARENT_SUSPEND, id);
        }
        if (execution.isCompleted() || execution.isTerminated()) {
            throw LOG.wrongCaseStateException(TRANSITION_PARENT_SUSPEND, id, "[available|enabled|disabled|active]", execution.getCurrentState().toString());
        }
        this.performParentSuspension(execution);
    }

    @Override
    public void onResume(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_RESUME);
        this.ensureTransitionAllowed(execution, CaseExecutionState.SUSPENDED, CaseExecutionState.ACTIVE, TRANSITION_RESUME);
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            String id = execution.getId();
            throw LOG.resumeInactiveCaseException(TRANSITION_RESUME, id);
        }
        this.resuming(execution);
    }

    @Override
    public void onParentResume(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, TRANSITION_PARENT_RESUME);
        String id = execution.getId();
        if (!execution.isSuspended()) {
            throw LOG.wrongCaseStateException(TRANSITION_PARENT_RESUME, id, "suspended", execution.getCurrentState().toString());
        }
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            throw LOG.resumeInactiveCaseException(TRANSITION_PARENT_RESUME, id);
        }
        this.resuming(execution);
    }

    @Override
    public void onOccur(CmmnActivityExecution execution) {
        String id = execution.getId();
        throw LOG.illegalStateTransitionException("occur", id, this.getTypeName());
    }

    @Override
    public void fireEntryCriteria(CmmnActivityExecution execution) {
        boolean manualActivation = this.evaluateManualActivationRule(execution);
        if (manualActivation) {
            execution.enable();
        } else {
            execution.start();
        }
    }

    protected boolean evaluateManualActivationRule(CmmnActivityExecution execution) {
        boolean manualActivation = false;
        CmmnActivity activity = execution.getActivity();
        Object manualActivationRule = activity.getProperty("manualActivationRule");
        if (manualActivationRule != null) {
            CaseControlRule rule = (CaseControlRule)manualActivationRule;
            manualActivation = rule.evaluate(execution);
        }
        return manualActivation;
    }

    protected abstract String getTypeName();
}

