/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.cmd;

import io.openbpm.bpm.engine.exception.cmmn.CaseExecutionNotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class GetCaseExecutionVariableCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseExecutionId;
    protected String variableName;
    protected boolean isLocal;

    public GetCaseExecutionVariableCmd(String caseExecutionId, String variableName, boolean isLocal) {
        this.caseExecutionId = caseExecutionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseExecutionId", (Object)this.caseExecutionId);
        EnsureUtil.ensureNotNull("variableName", (Object)this.variableName);
        CaseExecutionEntity caseExecution = commandContext.getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        EnsureUtil.ensureNotNull(CaseExecutionNotFoundException.class, "case execution " + this.caseExecutionId + " doesn't exist", "caseExecution", (Object)caseExecution);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseInstance(caseExecution);
        }
        Object value = this.isLocal ? caseExecution.getVariableLocal(this.variableName) : caseExecution.getVariable(this.variableName);
        return value;
    }
}

