/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.cmd;

import io.openbpm.bpm.engine.exception.cmmn.CmmnModelInstanceNotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.model.cmmn.CmmnModelInstance;

public class GetDeploymentCmmnModelInstanceCmd
implements Command<CmmnModelInstance> {
    protected String caseDefinitionId;

    public GetDeploymentCmmnModelInstanceCmd(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public CmmnModelInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)this.caseDefinitionId);
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        CaseDefinitionEntity caseDefinition = deploymentCache.findDeployedCaseDefinitionById(this.caseDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseDefinition(caseDefinition);
        }
        CmmnModelInstance modelInstance = Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        EnsureUtil.ensureNotNull(CmmnModelInstanceNotFoundException.class, "No CMMN model instance found for case definition id " + this.caseDefinitionId, "modelInstance", (Object)modelInstance);
        return modelInstance;
    }
}

