/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.entity.runtime;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.ProcessEngineServices;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import io.openbpm.bpm.engine.impl.cfg.multitenancy.TenantIdProviderCaseInstanceContext;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartEntity;
import io.openbpm.bpm.engine.impl.cmmn.execution.CmmnExecution;
import io.openbpm.bpm.engine.impl.cmmn.execution.CmmnSentryPart;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnActivity;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import io.openbpm.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.core.instance.CoreExecution;
import io.openbpm.bpm.engine.impl.core.operation.CoreAtomicOperation;
import io.openbpm.bpm.engine.impl.core.variable.CoreVariableInstance;
import io.openbpm.bpm.engine.impl.core.variable.scope.CmmnVariableInvocationListener;
import io.openbpm.bpm.engine.impl.core.variable.scope.VariableInstanceFactory;
import io.openbpm.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import io.openbpm.bpm.engine.impl.core.variable.scope.VariableOnPartListener;
import io.openbpm.bpm.engine.impl.core.variable.scope.VariableStore;
import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.db.HasDbReferences;
import io.openbpm.bpm.engine.impl.db.HasDbRevision;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.handler.HistoryEventHandler;
import io.openbpm.bpm.engine.impl.history.producer.CmmnHistoryEventProducer;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.CaseExecutionEntityReferencer;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntityFactory;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntityPersistenceListener;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceHistoryListener;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceSequenceCounterListener;
import io.openbpm.bpm.engine.impl.pvm.PvmProcessDefinition;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import io.openbpm.bpm.engine.impl.task.TaskDecorator;
import io.openbpm.bpm.engine.repository.CaseDefinition;
import io.openbpm.bpm.engine.runtime.CaseExecution;
import io.openbpm.bpm.engine.runtime.CaseInstance;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.model.cmmn.CmmnModelInstance;
import io.openbpm.bpm.model.cmmn.instance.CmmnElement;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.type.ModelElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CaseExecutionEntity
extends CmmnExecution
implements CaseExecution,
CaseInstance,
DbEntity,
HasDbRevision,
HasDbReferences,
VariableStore.VariablesProvider<VariableInstanceEntity> {
    private static final long serialVersionUID = 1L;
    protected transient CaseExecutionEntity caseInstance;
    protected transient CaseExecutionEntity parent;
    protected List<CaseExecutionEntity> caseExecutions;
    protected List<CaseSentryPartEntity> caseSentryParts;
    protected Map<String, List<CmmnSentryPart>> sentries;
    protected transient ExecutionEntity subProcessInstance;
    protected transient ExecutionEntity superExecution;
    protected transient CaseExecutionEntity subCaseInstance;
    protected transient CaseExecutionEntity superCaseExecution;
    protected VariableStore<VariableInstanceEntity> variableStore = new VariableStore<VariableInstanceEntity>(this, new CaseExecutionEntityReferencer(this));
    protected int revision = 1;
    protected String caseDefinitionId;
    protected String activityId;
    protected String caseInstanceId;
    protected String parentId;
    protected String superCaseExecutionId;
    protected String superExecutionId;
    protected String activityName;
    protected String activityType;
    protected String activityDescription;

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Override
    public CmmnCaseDefinition getCaseDefinition() {
        this.ensureCaseDefinitionInitialized();
        return this.caseDefinition;
    }

    @Override
    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        super.setCaseDefinition(caseDefinition);
        this.caseDefinitionId = null;
        if (caseDefinition != null) {
            this.caseDefinitionId = caseDefinition.getId();
        }
    }

    protected void ensureCaseDefinitionInitialized() {
        if (this.caseDefinition == null && this.caseDefinitionId != null) {
            CaseDefinitionEntity deployedCaseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().getCaseDefinitionById(this.caseDefinitionId);
            this.setCaseDefinition(deployedCaseDefinition);
        }
    }

    @Override
    public CaseExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (CaseExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureCaseExecutionTreeInitialized();
            } else {
                this.parent = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.parentId);
            }
        }
    }

    protected void ensureCaseExecutionTreeInitialized() {
        List<CaseExecutionEntity> executions = Context.getCommandContext().getCaseExecutionManager().findChildCaseExecutionsByCaseInstanceId(this.caseInstanceId);
        CaseExecutionEntity caseExecutionInstance = null;
        HashMap<String, CaseExecutionEntity> executionMap = new HashMap<String, CaseExecutionEntity>();
        for (CaseExecutionEntity execution : executions) {
            execution.caseExecutions = new ArrayList<CaseExecutionEntity>();
            executionMap.put(execution.getId(), execution);
            if (!execution.isCaseInstanceExecution()) continue;
            caseExecutionInstance = execution;
        }
        for (CaseExecutionEntity execution : executions) {
            CaseExecutionEntity parent = (CaseExecutionEntity)executionMap.get(execution.getParentId());
            if (!execution.isCaseInstanceExecution()) {
                execution.caseInstance = caseExecutionInstance;
                execution.parent = parent;
                parent.caseExecutions.add(execution);
                continue;
            }
            execution.caseInstance = execution;
        }
    }

    protected boolean isExecutionTreePrefetchEnabled() {
        return Context.getProcessEngineConfiguration().isExecutionTreePrefetchEnabled();
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public CmmnActivity getActivity() {
        this.ensureActivityInitialized();
        return super.getActivity();
    }

    @Override
    public void setActivity(CmmnActivity activity) {
        super.setActivity(activity);
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = activity.getName();
            this.activityType = this.getActivityProperty(activity, "activityType");
            this.activityDescription = this.getActivityProperty(activity, "description");
        } else {
            this.activityId = null;
            this.activityName = null;
            this.activityType = null;
            this.activityDescription = null;
        }
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getCaseDefinition().findActivity(this.activityId));
        }
    }

    protected String getActivityProperty(CmmnActivity activity, String property) {
        Object value;
        String result = null;
        if (activity != null && (value = activity.getProperty(property)) instanceof String) {
            String string;
            result = string = (String)value;
        }
        return result;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    public String getActivityType() {
        return this.activityType;
    }

    @Override
    public String getActivityDescription() {
        return this.activityDescription;
    }

    public List<CaseExecutionEntity> getCaseExecutions() {
        return new ArrayList<CaseExecutionEntity>(this.getCaseExecutionsInternal());
    }

    protected List<CaseExecutionEntity> getCaseExecutionsInternal() {
        this.ensureCaseExecutionsInitialized();
        return this.caseExecutions;
    }

    protected void ensureCaseExecutionsInitialized() {
        if (this.caseExecutions == null) {
            this.caseExecutions = Context.getCommandContext().getCaseExecutionManager().findChildCaseExecutionsByParentCaseExecutionId(this.id);
        }
    }

    @Override
    public TaskEntity getTask() {
        this.ensureTaskInitialized();
        return this.task;
    }

    protected void ensureTaskInitialized() {
        if (this.task == null) {
            this.task = Context.getCommandContext().getTaskManager().findTaskByCaseExecutionId(this.id);
        }
    }

    @Override
    public TaskEntity createTask(TaskDecorator taskDecorator) {
        TaskEntity task = super.createTask(taskDecorator);
        this.fireHistoricCaseActivityInstanceUpdate();
        return task;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public CaseExecutionEntity getCaseInstance() {
        this.ensureCaseInstanceInitialized();
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionEntity)caseInstance;
        if (caseInstance != null) {
            this.caseInstanceId = this.caseInstance.getId();
        }
    }

    protected void ensureCaseInstanceInitialized() {
        if (this.caseInstance == null && this.caseInstanceId != null) {
            this.caseInstance = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseInstanceId);
        }
    }

    @Override
    public boolean isCaseInstanceExecution() {
        return this.parentId == null;
    }

    @Override
    public void create(Map<String, Object> variables) {
        if (this.tenantId == null) {
            this.provideTenantId(variables);
        }
        super.create(variables);
    }

    protected void provideTenantId(Map<String, Object> variables) {
        TenantIdProvider tenantIdProvider = Context.getProcessEngineConfiguration().getTenantIdProvider();
        if (tenantIdProvider != null) {
            VariableMap variableMap = Variables.fromMap(variables);
            CaseDefinition caseDefinition = (CaseDefinition)((Object)this.getCaseDefinition());
            TenantIdProviderCaseInstanceContext ctx = null;
            ctx = this.superExecutionId != null ? new TenantIdProviderCaseInstanceContext(caseDefinition, variableMap, this.getSuperExecution()) : (this.superCaseExecutionId != null ? new TenantIdProviderCaseInstanceContext(caseDefinition, variableMap, this.getSuperCaseExecution()) : new TenantIdProviderCaseInstanceContext(caseDefinition, variableMap));
            this.tenantId = tenantIdProvider.provideTenantIdForCaseInstance(ctx);
        }
    }

    @Override
    protected CaseExecutionEntity createCaseExecution(CmmnActivity activity) {
        CaseExecutionEntity child = this.newCaseExecution();
        child.setActivity(activity);
        child.setParent(this);
        this.getCaseExecutionsInternal().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        if (this.tenantId != null) {
            child.setTenantId(this.tenantId);
        }
        return child;
    }

    @Override
    protected CaseExecutionEntity newCaseExecution() {
        CaseExecutionEntity newCaseExecution = new CaseExecutionEntity();
        Context.getCommandContext().getCaseExecutionManager().insertCaseExecution(newCaseExecution);
        return newCaseExecution;
    }

    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    public void setSuperExecutionId(String superProcessExecutionId) {
        this.superExecutionId = superProcessExecutionId;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInstanceInitialized();
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(PvmExecutionImpl superExecution) {
        if (this.superExecutionId != null) {
            this.ensureSuperExecutionInstanceInitialized();
            this.superExecution.setSubCaseInstance(null);
        }
        this.superExecution = (ExecutionEntity)superExecution;
        if (superExecution != null) {
            this.superExecutionId = superExecution.getId();
            this.superExecution.setSubCaseInstance(this);
        } else {
            this.superExecutionId = null;
        }
    }

    protected void ensureSuperExecutionInstanceInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = Context.getCommandContext().getExecutionManager().findExecutionById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        return this.createSubProcessInstance(processDefinition, businessKey, this.getCaseInstanceId());
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        ExecutionEntity subProcess = (ExecutionEntity)processDefinition.createProcessInstance(businessKey, caseInstanceId);
        String tenantId = ((ProcessDefinitionEntity)processDefinition).getTenantId();
        if (tenantId != null) {
            subProcess.setTenantId(tenantId);
        } else {
            subProcess.setTenantId(this.tenantId);
        }
        subProcess.setSuperCaseExecution(this);
        this.setSubProcessInstance(subProcess);
        this.fireHistoricCaseActivityInstanceUpdate();
        return subProcess;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperCaseExecutionId(this.id);
        }
    }

    @Override
    public CaseExecutionEntity getSubCaseInstance() {
        this.ensureSubCaseInstanceInitialized();
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.subCaseInstance = (CaseExecutionEntity)subCaseInstance;
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        return this.createSubCaseInstance(caseDefinition, null);
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition, String businessKey) {
        CaseExecutionEntity subCase = (CaseExecutionEntity)caseDefinition.createCaseInstance(businessKey);
        String tenantId = ((CaseDefinitionEntity)caseDefinition).getTenantId();
        if (tenantId != null) {
            subCase.setTenantId(tenantId);
        } else {
            subCase.setTenantId(this.tenantId);
        }
        subCase.setSuperCaseExecution(this);
        this.setSubCaseInstance(subCase);
        this.fireHistoricCaseActivityInstanceUpdate();
        return subCase;
    }

    public void fireHistoricCaseActivityInstanceUpdate() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE, this)) {
            CmmnHistoryEventProducer eventProducer = configuration.getCmmnHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent event = eventProducer.createCaseActivityInstanceUpdateEvt(this);
            eventHandler.handleEvent(event);
        }
    }

    protected void ensureSubCaseInstanceInitialized() {
        if (this.subCaseInstance == null) {
            this.subCaseInstance = Context.getCommandContext().getCaseExecutionManager().findSubCaseInstanceBySuperCaseExecutionId(this.id);
        }
    }

    public String getSuperCaseExecutionId() {
        return this.superCaseExecutionId;
    }

    public void setSuperCaseExecutionId(String superCaseExecutionId) {
        this.superCaseExecutionId = superCaseExecutionId;
    }

    @Override
    public CmmnExecution getSuperCaseExecution() {
        this.ensureSuperCaseExecutionInitialized();
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionEntity)superCaseExecution;
        this.superCaseExecutionId = superCaseExecution != null ? superCaseExecution.getId() : null;
    }

    protected void ensureSuperCaseExecutionInitialized() {
        if (this.superCaseExecution == null && this.superCaseExecutionId != null) {
            this.superCaseExecution = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.superCaseExecutionId);
        }
    }

    public List<CaseSentryPartEntity> getCaseSentryParts() {
        this.ensureCaseSentryPartsInitialized();
        return this.caseSentryParts;
    }

    protected void ensureCaseSentryPartsInitialized() {
        if (this.caseSentryParts == null) {
            this.caseSentryParts = Context.getCommandContext().getCaseSentryPartManager().findCaseSentryPartsByCaseExecutionId(this.id);
            this.sentries = new HashMap<String, List<CmmnSentryPart>>();
            for (CaseSentryPartEntity sentryPart : this.caseSentryParts) {
                String sentryId = sentryPart.getSentryId();
                this.sentries.computeIfAbsent(sentryId, k -> new ArrayList()).add(sentryPart);
            }
        }
    }

    @Override
    protected void addSentryPart(CmmnSentryPart sentryPart) {
        CaseSentryPartEntity entity = (CaseSentryPartEntity)sentryPart;
        this.getCaseSentryParts().add(entity);
        String sentryId = sentryPart.getSentryId();
        List parts = this.sentries.computeIfAbsent(sentryId, k -> new ArrayList());
        parts.add(entity);
    }

    @Override
    protected Map<String, List<CmmnSentryPart>> getSentries() {
        this.ensureCaseSentryPartsInitialized();
        return this.sentries;
    }

    protected List<CmmnSentryPart> findSentry(String sentryId) {
        this.ensureCaseSentryPartsInitialized();
        return this.sentries.get(sentryId);
    }

    @Override
    protected CaseSentryPartEntity newSentryPart() {
        CaseSentryPartEntity caseSentryPart = new CaseSentryPartEntity();
        Context.getCommandContext().getCaseSentryPartManager().insertCaseSentryPart(caseSentryPart);
        return caseSentryPart;
    }

    @Override
    protected VariableStore<CoreVariableInstance> getVariableStore() {
        return this.variableStore;
    }

    @Override
    protected VariableInstanceFactory<CoreVariableInstance> getVariableInstanceFactory() {
        return VariableInstanceEntityFactory.INSTANCE;
    }

    @Override
    protected List<VariableInstanceLifecycleListener<CoreVariableInstance>> getVariableInstanceLifecycleListeners() {
        return Arrays.asList(VariableInstanceEntityPersistenceListener.INSTANCE, VariableInstanceSequenceCounterListener.INSTANCE, VariableInstanceHistoryListener.INSTANCE, CmmnVariableInvocationListener.INSTANCE, new VariableOnPartListener(this));
    }

    @Override
    public Collection<VariableInstanceEntity> provideVariables() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByCaseExecutionId(this.id);
    }

    @Override
    public Collection<VariableInstanceEntity> provideVariables(Collection<String> variableNames) {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByCaseExecutionIdAndVariableNames(this.id, variableNames);
    }

    @Override
    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CaseExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public void remove() {
        super.remove();
        for (VariableInstanceEntity variableInstance : this.variableStore.getVariables()) {
            this.invokeVariableLifecycleListenersDelete(variableInstance, this, Arrays.asList(VariableInstanceEntityPersistenceListener.INSTANCE));
            this.variableStore.removeVariable(variableInstance.getName());
        }
        CommandContext commandContext = Context.getCommandContext();
        for (CaseSentryPartEntity sentryPart : this.getCaseSentryParts()) {
            commandContext.getCaseSentryPartManager().deleteSentryPart(sentryPart);
        }
        commandContext.getCaseExecutionManager().deleteCaseExecution(this);
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void forceUpdate() {
        Context.getCommandContext().getDbEntityManager().forceUpdate(this);
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referenceIds = new HashSet<String>();
        if (this.parentId != null) {
            referenceIds.add(this.parentId);
        }
        if (this.superCaseExecutionId != null) {
            referenceIds.add(this.superCaseExecutionId);
        }
        return referenceIds;
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        if (this.parentId != null) {
            referenceIdAndClass.put(this.parentId, CaseExecutionEntity.class);
        }
        if (this.superCaseExecutionId != null) {
            referenceIdAndClass.put(this.superCaseExecutionId, CaseExecutionEntity.class);
        }
        if (this.caseDefinitionId != null) {
            referenceIdAndClass.put(this.caseDefinitionId, CmmnCaseDefinition.class);
        }
        return referenceIdAndClass;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("caseDefinitionId", this.caseDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("parentId", this.parentId);
        persistentState.put("currentState", this.currentState);
        persistentState.put("previousState", this.previousState);
        persistentState.put("superExecutionId", this.superExecutionId);
        return persistentState;
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance() {
        if (this.caseDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        }
        return null;
    }

    @Override
    public CmmnElement getCmmnModelElementInstance() {
        CmmnModelInstance cmmnModelInstance = this.getCmmnModelInstance();
        if (cmmnModelInstance != null) {
            ModelElementInstance modelElementInstance = cmmnModelInstance.getModelElementById(this.activityId);
            try {
                return (CmmnElement)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw new ProcessEngineException("Cannot cast " + modelElementInstance + " to CmmnElement. Is of type " + elementType.getTypeName() + " Namespace " + elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }

    @Override
    public ProcessEngine getProcessEngine() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }

    public String getCaseDefinitionTenantId() {
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)this.getCaseDefinition();
        return caseDefinition.getTenantId();
    }

    @Override
    public <T extends CoreExecution> void performOperation(CoreAtomicOperation<T> operation) {
        Context.getCommandContext().performOperation((CmmnAtomicOperation)operation, this);
    }

    @Override
    public <T extends CoreExecution> void performOperationSync(CoreAtomicOperation<T> operation) {
        Context.getCommandContext().performOperation((CmmnAtomicOperation)operation, this);
    }
}

