/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.handler;

import io.openbpm.bpm.engine.impl.cmmn.behavior.ProcessOrCaseTaskActivityBehavior;
import io.openbpm.bpm.engine.impl.cmmn.handler.CallingTaskItemHandler;
import io.openbpm.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnActivity;
import io.openbpm.bpm.engine.impl.core.model.CallableElement;
import io.openbpm.bpm.engine.impl.core.model.CallableElementParameter;
import io.openbpm.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.model.cmmn.instance.CmmnElement;
import io.openbpm.bpm.model.cmmn.instance.PlanItemDefinition;
import io.openbpm.bpm.model.cmmn.instance.operaton.OperatonIn;
import io.openbpm.bpm.model.cmmn.instance.operaton.OperatonOut;
import java.util.List;

public abstract class ProcessOrCaseTaskItemHandler
extends CallingTaskItemHandler {
    @Override
    protected CallableElement createCallableElement() {
        return new CallableElement();
    }

    @Override
    protected void initializeCallableElement(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeCallableElement(element, activity, context);
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        this.initializeInputParameter(element, activity, context, callableElement);
        this.initializeOutputParameter(element, activity, context, callableElement);
    }

    protected void initializeInputParameter(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        List<OperatonIn> inputs = this.getInputs(element);
        for (OperatonIn input : inputs) {
            String variables;
            String businessKey = input.getOperatonBusinessKey();
            if (businessKey != null && !businessKey.isEmpty()) {
                ParameterValueProvider businessKeyValueProvider = this.createParameterValueProvider(businessKey, expressionManager);
                callableElement.setBusinessKeyValueProvider(businessKeyValueProvider);
                continue;
            }
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addInput(parameter);
            if (input.getOperatonLocal()) {
                parameter.setReadLocal(true);
            }
            if ("all".equals(variables = input.getOperatonVariables())) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = input.getOperatonSource();
            if (source == null || source.isEmpty()) {
                source = input.getOperatonSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = input.getOperatonTarget();
            parameter.setTarget(target);
        }
    }

    protected void initializeOutputParameter(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        List<OperatonOut> outputs = this.getOutputs(element);
        for (OperatonOut output : outputs) {
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addOutput(parameter);
            String variables = output.getOperatonVariables();
            if ("all".equals(variables)) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = output.getOperatonSource();
            if (source == null || source.isEmpty()) {
                source = output.getOperatonSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = output.getOperatonTarget();
            parameter.setTarget(target);
        }
    }

    protected List<OperatonIn> getInputs(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return this.queryExtensionElementsByClass((CmmnElement)definition, OperatonIn.class);
    }

    protected List<OperatonOut> getOutputs(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return this.queryExtensionElementsByClass((CmmnElement)definition, OperatonOut.class);
    }
}

