/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.listener;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.CaseExecutionListener;
import io.openbpm.bpm.engine.delegate.DelegateCaseExecution;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.cmmn.delegate.CaseExecutionListenerInvocation;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.util.ClassDelegateUtil;
import java.util.List;

public class DelegateExpressionCaseExecutionListener
implements CaseExecutionListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionCaseExecutionListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateCaseExecution caseExecution) throws Exception {
        Object delegate = this.expression.getValue(caseExecution);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (!(delegate instanceof CaseExecutionListener)) {
            throw new ProcessEngineException("Delegate expression " + this.expression + " did not resolve to an implementation of " + CaseExecutionListener.class);
        }
        CaseExecutionListener listenerInstance = (CaseExecutionListener)delegate;
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new CaseExecutionListenerInvocation(listenerInstance, caseExecution));
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }
}

