/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmmn.transformer;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import io.openbpm.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import io.openbpm.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import io.openbpm.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import io.openbpm.bpm.engine.impl.cmmn.handler.DefaultCmmnElementHandlerRegistry;
import io.openbpm.bpm.engine.impl.cmmn.handler.ItemHandler;
import io.openbpm.bpm.engine.impl.cmmn.handler.SentryHandler;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnActivity;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import io.openbpm.bpm.engine.impl.cmmn.transformer.CmmnTransformListener;
import io.openbpm.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import io.openbpm.bpm.engine.impl.cmmn.transformer.CmmnTransformerLogger;
import io.openbpm.bpm.engine.impl.core.transformer.Transform;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ResourceEntity;
import io.openbpm.bpm.model.cmmn.Cmmn;
import io.openbpm.bpm.model.cmmn.CmmnModelException;
import io.openbpm.bpm.model.cmmn.CmmnModelInstance;
import io.openbpm.bpm.model.cmmn.impl.instance.CasePlanModel;
import io.openbpm.bpm.model.cmmn.instance.Case;
import io.openbpm.bpm.model.cmmn.instance.CaseTask;
import io.openbpm.bpm.model.cmmn.instance.CmmnElement;
import io.openbpm.bpm.model.cmmn.instance.DecisionTask;
import io.openbpm.bpm.model.cmmn.instance.Definitions;
import io.openbpm.bpm.model.cmmn.instance.EventListener;
import io.openbpm.bpm.model.cmmn.instance.HumanTask;
import io.openbpm.bpm.model.cmmn.instance.Milestone;
import io.openbpm.bpm.model.cmmn.instance.PlanFragment;
import io.openbpm.bpm.model.cmmn.instance.PlanItem;
import io.openbpm.bpm.model.cmmn.instance.PlanItemDefinition;
import io.openbpm.bpm.model.cmmn.instance.PlanningTable;
import io.openbpm.bpm.model.cmmn.instance.ProcessTask;
import io.openbpm.bpm.model.cmmn.instance.Sentry;
import io.openbpm.bpm.model.cmmn.instance.Stage;
import io.openbpm.bpm.model.cmmn.instance.Task;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CmmnTransform
implements Transform<CaseDefinitionEntity> {
    protected static final CmmnTransformerLogger LOG = ProcessEngineLogger.CMMN_TRANSFORMER_LOGGER;
    protected CmmnTransformer transformer;
    protected ExpressionManager expressionManager;
    protected DefaultCmmnElementHandlerRegistry handlerRegistry;
    protected List<CmmnTransformListener> transformListeners;
    protected ResourceEntity resource;
    protected DeploymentEntity deployment;
    protected CmmnModelInstance model;
    protected CmmnHandlerContext context = new CmmnHandlerContext();
    protected List<CaseDefinitionEntity> caseDefinitions = new ArrayList<CaseDefinitionEntity>();

    public CmmnTransform(CmmnTransformer transformer) {
        this.transformer = transformer;
        this.expressionManager = transformer.getExpressionManager();
        this.handlerRegistry = transformer.getCmmnElementHandlerRegistry();
        this.transformListeners = transformer.getTransformListeners();
    }

    public CmmnTransform deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public CmmnTransform resource(ResourceEntity resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public List<CaseDefinitionEntity> transform() {
        String resourceName = this.resource.getName();
        byte[] bytes = this.resource.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            this.model = Cmmn.readModelFromStream((InputStream)inputStream);
        }
        catch (CmmnModelException e) {
            throw LOG.transformResourceException(resourceName, e);
        }
        this.context.setModel(this.model);
        this.context.setDeployment(this.deployment);
        this.context.setExpressionManager(this.expressionManager);
        try {
            this.transformRootElement();
        }
        catch (Exception e) {
            throw LOG.parseProcessException(resourceName, e);
        }
        return this.caseDefinitions;
    }

    protected void transformRootElement() {
        this.transformImports();
        this.transformCaseDefinitions();
        Definitions definitions = this.model.getDefinitions();
        for (CmmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformRootElement(definitions, this.caseDefinitions);
        }
    }

    protected void transformImports() {
    }

    protected void transformCaseDefinitions() {
        Definitions definitions = this.model.getDefinitions();
        Collection cases = definitions.getCases();
        for (Case currentCase : cases) {
            this.context.setCaseDefinition(null);
            this.context.setParent(null);
            CaseDefinitionEntity caseDefinition = this.transformCase(currentCase);
            this.caseDefinitions.add(caseDefinition);
        }
    }

    protected CaseDefinitionEntity transformCase(Case element) {
        CmmnElementHandler<Case, CmmnActivity> caseTransformer = this.getDefinitionHandler(Case.class);
        CmmnActivity definition = (CmmnActivity)caseTransformer.handleElement(element, this.context);
        this.context.setCaseDefinition((CmmnCaseDefinition)definition);
        this.context.setParent(definition);
        io.openbpm.bpm.model.cmmn.instance.CasePlanModel casePlanModel = element.getCasePlanModel();
        this.transformCasePlanModel(casePlanModel);
        for (CmmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformCase(element, (CmmnCaseDefinition)definition);
        }
        return (CaseDefinitionEntity)definition;
    }

    protected void transformCasePlanModel(io.openbpm.bpm.model.cmmn.instance.CasePlanModel casePlanModel) {
        CasePlanModelHandler planItemHandler = (CasePlanModelHandler)this.getPlanItemHandler(io.openbpm.bpm.model.cmmn.instance.CasePlanModel.class);
        CmmnActivity newActivity = planItemHandler.handleElement((CmmnElement)casePlanModel, this.context);
        this.context.setParent(newActivity);
        this.transformStage((Stage)casePlanModel, newActivity);
        this.context.setParent(newActivity);
        planItemHandler.initializeExitCriterias(casePlanModel, newActivity, this.context);
        for (CmmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformCasePlanModel((CasePlanModel)casePlanModel, newActivity);
        }
    }

    protected void transformStage(Stage stage, CmmnActivity parent) {
        this.context.setParent(parent);
        this.transformSentries(stage);
        this.transformPlanItems((PlanFragment)stage, parent);
        this.transformSentryOnParts(stage);
        this.transformPlanningTable(stage.getPlanningTable(), parent);
    }

    protected void transformPlanningTable(PlanningTable planningTable, CmmnActivity parent) {
    }

    protected void transformSentries(Stage stage) {
        Collection sentries = stage.getSentrys();
        if (sentries != null && !sentries.isEmpty()) {
            SentryHandler handler = this.getSentryHandler();
            for (Sentry sentry : sentries) {
                handler.handleElement(sentry, this.context);
            }
        }
    }

    protected void transformSentryOnParts(Stage stage) {
        Collection sentries = stage.getSentrys();
        if (sentries != null && !sentries.isEmpty()) {
            SentryHandler handler = this.getSentryHandler();
            for (Sentry sentry : sentries) {
                handler.initializeOnParts(sentry, this.context);
                CmmnSentryDeclaration sentryDeclaration = this.context.getParent().getSentry(sentry.getId());
                for (CmmnTransformListener transformListener : this.transformListeners) {
                    transformListener.transformSentry(sentry, sentryDeclaration);
                }
            }
        }
    }

    protected void transformPlanItems(PlanFragment planFragment, CmmnActivity parent) {
        Collection planItems = planFragment.getPlanItems();
        for (PlanItem planItem : planItems) {
            this.transformPlanItem(planItem, parent);
        }
    }

    protected void transformPlanItem(PlanItem planItem, CmmnActivity parent) {
        PlanItemDefinition definition = planItem.getDefinition();
        ItemHandler planItemTransformer = null;
        if (definition instanceof HumanTask) {
            planItemTransformer = this.getPlanItemHandler(HumanTask.class);
        } else if (definition instanceof ProcessTask) {
            planItemTransformer = this.getPlanItemHandler(ProcessTask.class);
        } else if (definition instanceof CaseTask) {
            planItemTransformer = this.getPlanItemHandler(CaseTask.class);
        } else if (definition instanceof DecisionTask) {
            planItemTransformer = this.getPlanItemHandler(DecisionTask.class);
        } else if (definition instanceof Task) {
            planItemTransformer = this.getPlanItemHandler(Task.class);
        } else if (definition instanceof Stage) {
            planItemTransformer = this.getPlanItemHandler(Stage.class);
        } else if (definition instanceof Milestone) {
            planItemTransformer = this.getPlanItemHandler(Milestone.class);
        } else if (definition instanceof EventListener) {
            planItemTransformer = this.getPlanItemHandler(EventListener.class);
        }
        if (planItemTransformer != null) {
            CmmnActivity newActivity = planItemTransformer.handleElement((CmmnElement)planItem, this.context);
            if (definition instanceof Stage) {
                Stage stage = (Stage)definition;
                this.transformStage(stage, newActivity);
                this.context.setParent(parent);
            } else if (definition instanceof HumanTask) {
                HumanTask humanTask = (HumanTask)definition;
                Collection planningTables = humanTask.getPlanningTables();
                for (PlanningTable planningTable : planningTables) {
                    this.transformPlanningTable(planningTable, parent);
                }
            }
            for (CmmnTransformListener transformListener : this.transformListeners) {
                if (definition instanceof HumanTask) {
                    HumanTask task = (HumanTask)definition;
                    transformListener.transformHumanTask(planItem, task, newActivity);
                    continue;
                }
                if (definition instanceof ProcessTask) {
                    ProcessTask task = (ProcessTask)definition;
                    transformListener.transformProcessTask(planItem, task, newActivity);
                    continue;
                }
                if (definition instanceof CaseTask) {
                    CaseTask task = (CaseTask)definition;
                    transformListener.transformCaseTask(planItem, task, newActivity);
                    continue;
                }
                if (definition instanceof DecisionTask) {
                    DecisionTask task = (DecisionTask)definition;
                    transformListener.transformDecisionTask(planItem, task, newActivity);
                    continue;
                }
                if (definition instanceof Task) {
                    Task task = (Task)definition;
                    transformListener.transformTask(planItem, task, newActivity);
                    continue;
                }
                if (definition instanceof Stage) {
                    Stage stage = (Stage)definition;
                    transformListener.transformStage(planItem, stage, newActivity);
                    continue;
                }
                if (definition instanceof Milestone) {
                    Milestone milestone = (Milestone)definition;
                    transformListener.transformMilestone(planItem, milestone, newActivity);
                    continue;
                }
                if (!(definition instanceof EventListener)) continue;
                EventListener listener = (EventListener)definition;
                transformListener.transformEventListener(planItem, listener, newActivity);
            }
        }
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public ResourceEntity getResource() {
        return this.resource;
    }

    public void setResource(ResourceEntity resource) {
        this.resource = resource;
    }

    public DefaultCmmnElementHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public void setHandlerRegistry(DefaultCmmnElementHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    protected <V extends CmmnElement> CmmnElementHandler<V, CmmnActivity> getDefinitionHandler(Class<V> cls) {
        return this.getHandlerRegistry().getDefinitionElementHandlers().get(cls);
    }

    protected ItemHandler getPlanItemHandler(Class<? extends PlanItemDefinition> cls) {
        return this.getHandlerRegistry().getPlanItemElementHandlers().get(cls);
    }

    protected ItemHandler getDiscretionaryItemHandler(Class<? extends PlanItemDefinition> cls) {
        return this.getHandlerRegistry().getDiscretionaryElementHandlers().get(cls);
    }

    protected SentryHandler getSentryHandler() {
        return this.getHandlerRegistry().getSentryHandler();
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

