/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.context;

import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.impl.ProcessApplicationLogger;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.application.ProcessApplicationManager;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.CoreExecutionContext;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationClassloaderInterceptor;
import io.openbpm.bpm.engine.impl.core.instance.CoreExecution;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.repository.ResourceDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.ClassLoaderUtil;

public final class ProcessApplicationContextUtil {
    private static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;

    public static ProcessApplicationReference getTargetProcessApplication(CoreExecution execution) {
        if (execution instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            return ProcessApplicationContextUtil.getTargetProcessApplication(executionEntity);
        }
        return ProcessApplicationContextUtil.getTargetProcessApplication((CaseExecutionEntity)execution);
    }

    public static ProcessApplicationReference getTargetProcessApplication(ExecutionEntity execution) {
        if (execution == null) {
            return null;
        }
        ProcessApplicationReference processApplicationForDeployment = ProcessApplicationContextUtil.getTargetProcessApplication(execution.getProcessDefinition());
        if (LOG.isContextSwitchLoggable() && processApplicationForDeployment == null) {
            ProcessApplicationContextUtil.loggContextSwitchDetails(execution);
        }
        return processApplicationForDeployment;
    }

    public static ProcessApplicationReference getTargetProcessApplication(CaseExecutionEntity execution) {
        if (execution == null) {
            return null;
        }
        ProcessApplicationReference processApplicationForDeployment = ProcessApplicationContextUtil.getTargetProcessApplication((CaseDefinitionEntity)execution.getCaseDefinition());
        if (LOG.isContextSwitchLoggable() && processApplicationForDeployment == null) {
            ProcessApplicationContextUtil.loggContextSwitchDetails(execution);
        }
        return processApplicationForDeployment;
    }

    public static ProcessApplicationReference getTargetProcessApplication(TaskEntity task) {
        if (task.getProcessDefinition() != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(task.getProcessDefinition());
        }
        if (task.getCaseDefinition() != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(task.getCaseDefinition());
        }
        return null;
    }

    public static ProcessApplicationReference getTargetProcessApplication(ResourceDefinitionEntity definition) {
        ProcessApplicationReference reference = ProcessApplicationContextUtil.getTargetProcessApplication(definition.getDeploymentId());
        if (reference == null && ProcessApplicationContextUtil.areProcessApplicationsRegistered()) {
            for (ResourceDefinitionEntity previous = definition.getPreviousDefinition(); previous != null; previous = previous.getPreviousDefinition()) {
                reference = ProcessApplicationContextUtil.getTargetProcessApplication(previous.getDeploymentId());
                if (reference == null) {
                    continue;
                }
                return reference;
            }
        }
        return reference;
    }

    public static ProcessApplicationReference getTargetProcessApplication(String deploymentId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessApplicationManager processApplicationManager = processEngineConfiguration.getProcessApplicationManager();
        return processApplicationManager.getProcessApplicationForDeployment(deploymentId);
    }

    public static boolean areProcessApplicationsRegistered() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessApplicationManager processApplicationManager = processEngineConfiguration.getProcessApplicationManager();
        return processApplicationManager.hasRegistrations();
    }

    private static void loggContextSwitchDetails(ExecutionEntity execution) {
        CoreExecutionContext<? extends CoreExecution> executionContext = Context.getCoreExecutionContext();
        if (executionContext == null || executionContext.getExecution() != execution) {
            ProcessApplicationManager processApplicationManager = Context.getProcessEngineConfiguration().getProcessApplicationManager();
            LOG.debugNoTargetProcessApplicationFound(execution, processApplicationManager);
        }
    }

    private static void loggContextSwitchDetails(CaseExecutionEntity execution) {
        CoreExecutionContext<? extends CoreExecution> executionContext = Context.getCoreExecutionContext();
        if (executionContext == null || executionContext.getExecution() != execution) {
            ProcessApplicationManager processApplicationManager = Context.getProcessEngineConfiguration().getProcessApplicationManager();
            LOG.debugNoTargetProcessApplicationFoundForCaseExecution(execution, processApplicationManager);
        }
    }

    public static boolean requiresContextSwitch(ProcessApplicationReference processApplicationReference) {
        ProcessApplicationReference currentProcessApplication = Context.getCurrentProcessApplication();
        if (processApplicationReference == null) {
            return false;
        }
        if (currentProcessApplication == null) {
            return true;
        }
        if (!processApplicationReference.getName().equals(currentProcessApplication.getName())) {
            return true;
        }
        ClassLoader processApplicationClassLoader = ProcessApplicationClassloaderInterceptor.getProcessApplicationClassLoader();
        ClassLoader currentClassloader = ClassLoaderUtil.getContextClassloader();
        return currentClassloader != processApplicationClassLoader;
    }

    public static void doContextSwitch(Runnable runnable, ProcessDefinitionEntity contextDefinition) {
        ProcessApplicationReference processApplication = ProcessApplicationContextUtil.getTargetProcessApplication(contextDefinition);
        if (ProcessApplicationContextUtil.requiresContextSwitch(processApplication)) {
            Context.executeWithinProcessApplication(() -> {
                runnable.run();
                return null;
            }, processApplication);
        } else {
            runnable.run();
        }
    }

    private ProcessApplicationContextUtil() {
    }
}

