/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.core.instance;

import io.openbpm.bpm.engine.delegate.BaseDelegateExecution;
import io.openbpm.bpm.engine.delegate.DelegateListener;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.core.CoreLogger;
import io.openbpm.bpm.engine.impl.core.model.CoreModelElement;
import io.openbpm.bpm.engine.impl.core.operation.CoreAtomicOperation;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;

public abstract class CoreExecution
extends AbstractVariableScope
implements BaseDelegateExecution {
    private static final long serialVersionUID = 1L;
    private static final CoreLogger LOG = ProcessEngineLogger.CORE_LOGGER;
    protected String id;
    protected String businessKey;
    protected String businessKeyWithoutCascade;
    protected String tenantId;
    protected String eventName;
    protected CoreModelElement eventSource;
    protected int listenerIndex;
    protected boolean skipCustomListeners;
    protected boolean skipIoMapping;
    protected boolean skipSubprocesses;

    public <T extends CoreExecution> void performOperation(CoreAtomicOperation<T> operation) {
        LOG.debugPerformingAtomicOperation(operation, this);
        operation.execute(this);
    }

    public <T extends CoreExecution> void performOperationSync(CoreAtomicOperation<T> operation) {
        LOG.debugPerformingAtomicOperation(operation, this);
        operation.execute(this);
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public CoreModelElement getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(CoreModelElement eventSource) {
        this.eventSource = eventSource;
    }

    public int getListenerIndex() {
        return this.listenerIndex;
    }

    public void setListenerIndex(int listenerIndex) {
        this.listenerIndex = listenerIndex;
    }

    public void invokeListener(DelegateListener listener) throws Exception {
        listener.notify(this);
    }

    public boolean hasFailedOnEndListeners() {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBusinessKeyWithoutCascade() {
        return this.businessKeyWithoutCascade;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        this.businessKeyWithoutCascade = businessKey;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public void setSkipCustomListeners(boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public boolean isSkipIoMappings() {
        return this.skipIoMapping;
    }

    public void setSkipIoMappings(boolean skipIoMappings) {
        this.skipIoMapping = skipIoMappings;
    }

    public boolean isSkipSubprocesses() {
        return this.skipSubprocesses;
    }

    public void setSkipSubprocesseses(boolean skipSubprocesses) {
        this.skipSubprocesses = skipSubprocesses;
    }
}

