/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.core.model;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;

public class BaseCallableElement {
    protected ParameterValueProvider definitionKeyValueProvider;
    protected CallableElementBinding binding;
    protected ParameterValueProvider versionValueProvider;
    protected ParameterValueProvider versionTagValueProvider;
    protected ParameterValueProvider tenantIdProvider;
    protected String deploymentId;

    public String getDefinitionKey(VariableScope variableScope) {
        Object result = this.definitionKeyValueProvider.getValue(variableScope);
        if (result != null && !(result instanceof String)) {
            throw new ClassCastException("Cannot cast '" + result + "' to String");
        }
        return (String)result;
    }

    public ParameterValueProvider getDefinitionKeyValueProvider() {
        return this.definitionKeyValueProvider;
    }

    public void setDefinitionKeyValueProvider(ParameterValueProvider definitionKey) {
        this.definitionKeyValueProvider = definitionKey;
    }

    public CallableElementBinding getBinding() {
        return this.binding;
    }

    public void setBinding(CallableElementBinding binding) {
        this.binding = binding;
    }

    public boolean isLatestBinding() {
        CallableElementBinding elementBinding = this.getBinding();
        return elementBinding == null || CallableElementBinding.LATEST.equals((Object)elementBinding);
    }

    public boolean isDeploymentBinding() {
        return CallableElementBinding.DEPLOYMENT.equals((Object)this.getBinding());
    }

    public boolean isVersionBinding() {
        return CallableElementBinding.VERSION.equals((Object)this.getBinding());
    }

    public boolean isVersionTagBinding() {
        return CallableElementBinding.VERSION_TAG.equals((Object)this.getBinding());
    }

    public Integer getVersion(VariableScope variableScope) {
        Object result = this.versionValueProvider.getValue(variableScope);
        if (result != null) {
            if (result instanceof String) {
                String string = (String)result;
                return Integer.valueOf(string);
            }
            if (result instanceof Integer) {
                Integer integer = (Integer)result;
                return integer;
            }
            throw new ProcessEngineException("It is not possible to transform '" + result + "' into an integer.");
        }
        return null;
    }

    public ParameterValueProvider getVersionValueProvider() {
        return this.versionValueProvider;
    }

    public void setVersionValueProvider(ParameterValueProvider version) {
        this.versionValueProvider = version;
    }

    public String getVersionTag(VariableScope variableScope) {
        Object result = this.versionTagValueProvider.getValue(variableScope);
        if (result != null) {
            if (result instanceof String) {
                String string = (String)result;
                return string;
            }
            throw new ProcessEngineException("It is not possible to transform '" + result + "' into a string.");
        }
        return null;
    }

    public ParameterValueProvider getVersionTagValueProvider() {
        return this.versionTagValueProvider;
    }

    public void setVersionTagValueProvider(ParameterValueProvider version) {
        this.versionTagValueProvider = version;
    }

    public void setTenantIdProvider(ParameterValueProvider tenantIdProvider) {
        this.tenantIdProvider = tenantIdProvider;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDefinitionTenantId(VariableScope variableScope, String defaultTenantId) {
        if (this.tenantIdProvider != null) {
            return (String)this.tenantIdProvider.getValue(variableScope);
        }
        return defaultTenantId;
    }

    public ParameterValueProvider getTenantIdProvider() {
        return this.tenantIdProvider;
    }

    public boolean hasDynamicReferences() {
        return this.tenantIdProvider != null && this.tenantIdProvider.isDynamic() || this.definitionKeyValueProvider.isDynamic() || this.versionValueProvider.isDynamic() || this.versionTagValueProvider.isDynamic();
    }

    public static enum CallableElementBinding {
        LATEST("latest"),
        DEPLOYMENT("deployment"),
        VERSION("version"),
        VERSION_TAG("versionTag");

        private String value;

        private CallableElementBinding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

