/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.core.model;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.core.model.PropertyKey;
import io.openbpm.bpm.engine.impl.core.model.PropertyListKey;
import io.openbpm.bpm.engine.impl.core.model.PropertyMapKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Properties {
    protected final Map<String, Object> properties;

    public Properties() {
        this(new HashMap<String, Object>());
    }

    public Properties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public <T> T get(PropertyKey<T> property) {
        return (T)this.properties.get(property.name());
    }

    public <T> List<T> get(PropertyListKey<T> property) {
        if (this.contains(property)) {
            return (List)this.properties.get(property.name());
        }
        return new ArrayList();
    }

    public <K, V> Map<K, V> get(PropertyMapKey<K, V> property) {
        if (this.contains(property)) {
            return (Map)this.properties.get(property.name());
        }
        return new HashMap();
    }

    public <T> void set(PropertyKey<T> property, T value) {
        this.properties.put(property.name(), value);
    }

    public <T> void set(PropertyListKey<T> property, List<T> value) {
        this.properties.put(property.name(), value);
    }

    public <K, V> void set(PropertyMapKey<K, V> property, Map<K, V> value) {
        this.properties.put(property.name(), value);
    }

    public <T> void addListItem(PropertyListKey<T> property, T value) {
        List<T> list = this.get(property);
        list.add(value);
        if (!this.contains(property)) {
            this.set(property, list);
        }
    }

    public <K, V> void putMapEntry(PropertyMapKey<K, V> property, K key, V value) {
        Map<K, V> map = this.get(property);
        if (!property.allowsOverwrite() && map.containsKey(key)) {
            throw new ProcessEngineException("Cannot overwrite property key " + key + ". Key already exists");
        }
        map.put(key, value);
        if (!this.contains(property)) {
            this.set(property, map);
        }
    }

    public boolean contains(PropertyKey<?> property) {
        return this.properties.containsKey(property.name());
    }

    public boolean contains(PropertyListKey<?> property) {
        return this.properties.containsKey(property.name());
    }

    public boolean contains(PropertyMapKey<?, ?> property) {
        return this.properties.containsKey(property.name());
    }

    public Map<String, Object> toMap() {
        return new HashMap<String, Object>(this.properties);
    }

    public String toString() {
        return "Properties [properties=" + this.properties + "]";
    }
}

