/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.db;

import io.openbpm.bpm.engine.impl.cfg.IdGenerator;
import io.openbpm.bpm.engine.impl.cmd.GetNextIdBlockCmd;
import io.openbpm.bpm.engine.impl.db.IdBlock;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;

public class DbIdGenerator
implements IdGenerator {
    protected int idBlockSize;
    protected long nextId;
    protected long lastId;
    protected CommandExecutor commandExecutor;

    public DbIdGenerator() {
        this.reset();
    }

    @Override
    public synchronized String getNextId() {
        if (this.lastId < this.nextId) {
            this.getNewBlock();
        }
        long nextId = this.nextId++;
        return Long.toString(nextId);
    }

    protected synchronized void getNewBlock() {
        IdBlock idBlock = this.commandExecutor.execute(new GetNextIdBlockCmd(this.idBlockSize));
        this.nextId = idBlock.getNextId();
        this.lastId = idBlock.getLastId();
    }

    public int getIdBlockSize() {
        return this.idBlockSize;
    }

    public void setIdBlockSize(int idBlockSize) {
        this.idBlockSize = idBlockSize;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public void reset() {
        this.nextId = 0L;
        this.lastId = -1L;
    }
}

