/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.db;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineConfiguration;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.db.EnginePersistenceLogger;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class DbSchemaExecuteFile {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw LOG.invokeSchemaResourceToolException(args.length);
        }
        String configurationFileResourceName = args[0];
        String schemaFileResourceName = args[1];
        EnsureUtil.ensureNotNull("Process engine configuration file name cannot be null", "configurationFileResourceName", (Object)configurationFileResourceName);
        EnsureUtil.ensureNotNull("Schema resource file name cannot be null", "schemaFileResourceName", (Object)schemaFileResourceName);
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(configurationFileResourceName);
        ProcessEngine processEngine = configuration.buildProcessEngine();
        configuration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getDbSqlSession().executeSchemaResource(schemaFileResourceName);
            return null;
        });
        processEngine.close();
    }
}

