/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.digest._apacheCommonsCodec;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class StringUtils {
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    public static String newString(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, UTF_8);
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytesUnchecked(string, UTF_8);
    }

    public static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    private static IllegalStateException newIllegalStateException(String charsetName, UnsupportedEncodingException e) {
        return new IllegalStateException(charsetName + ": " + e);
    }

    private StringUtils() {
    }
}

