/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.dmn.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricDecisionInstanceQuery;
import io.openbpm.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.batch.BatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.BatchElementConfiguration;
import io.openbpm.bpm.engine.impl.batch.builder.BatchBuilder;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteHistoricDecisionInstancesBatchCmd
implements Command<Batch> {
    protected List<String> historicDecisionInstanceIds;
    protected HistoricDecisionInstanceQuery historicDecisionInstanceQuery;
    protected String deleteReason;

    public DeleteHistoricDecisionInstancesBatchCmd(List<String> ids, HistoricDecisionInstanceQuery query, String deleteReason) {
        this.historicDecisionInstanceIds = ids;
        this.historicDecisionInstanceQuery = query;
        this.deleteReason = deleteReason;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectHistoricDecisionInstanceIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicDecisionInstanceIds", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("historic-decision-instance-deletion").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected BatchElementConfiguration collectHistoricDecisionInstanceIds(CommandContext commandContext) {
        HistoricDecisionInstanceQueryImpl decisionInstanceQuery;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        if (!CollectionUtil.isEmpty(this.historicDecisionInstanceIds)) {
            HistoricDecisionInstanceQueryImpl query = new HistoricDecisionInstanceQueryImpl();
            query.decisionInstanceIdIn(this.historicDecisionInstanceIds.toArray(new String[0]));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings), this.historicDecisionInstanceIds);
        }
        if ((decisionInstanceQuery = (HistoricDecisionInstanceQueryImpl)this.historicDecisionInstanceQuery) != null) {
            elementConfiguration.addDeploymentMappings(decisionInstanceQuery.listDeploymentIdMappings());
        }
        return elementConfiguration;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("DeleteHistory", null, propertyChanges);
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new BatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings());
    }
}

