/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.dmn.cmd;

import io.openbpm.bpm.dmn.engine.DmnDecisionResult;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.dmn.DecisionEvaluationBuilderImpl;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.DecisionEvaluationUtil;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.repository.DecisionDefinition;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.Variables;
import java.util.ArrayList;

public class EvaluateDecisionCmd
implements Command<DmnDecisionResult> {
    protected String decisionDefinitionKey;
    protected String decisionDefinitionId;
    protected Integer version;
    protected VariableMap variables;
    protected String decisionDefinitionTenantId;
    protected boolean isTenantIdSet;

    public EvaluateDecisionCmd(DecisionEvaluationBuilderImpl builder) {
        this.decisionDefinitionKey = builder.getDecisionDefinitionKey();
        this.decisionDefinitionId = builder.getDecisionDefinitionId();
        this.version = builder.getVersion();
        this.variables = Variables.fromMap(builder.getVariables());
        this.decisionDefinitionTenantId = builder.getDecisionDefinitionTenantId();
        this.isTenantIdSet = builder.isTenantIdSet();
    }

    @Override
    public DmnDecisionResult execute(CommandContext commandContext) {
        EnsureUtil.ensureOnlyOneNotNull("either decision definition id or key must be set", this.decisionDefinitionId, this.decisionDefinitionKey);
        DecisionDefinition decisionDefinition = this.getDecisionDefinition(commandContext);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkEvaluateDecision(decisionDefinition);
        }
        this.writeUserOperationLog(commandContext, decisionDefinition);
        return this.doEvaluateDecision(decisionDefinition, this.variables);
    }

    protected void writeUserOperationLog(CommandContext commandContext, DecisionDefinition decisionDefinition) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("decisionDefinitionId", null, decisionDefinition.getId()));
        propertyChanges.add(new PropertyChange("decisionDefinitionKey", null, decisionDefinition.getKey()));
        commandContext.getOperationLogManager().logDecisionDefinitionOperation("Evaluate", decisionDefinition.getTenantId(), propertyChanges);
    }

    protected DmnDecisionResult doEvaluateDecision(DecisionDefinition decisionDefinition, VariableMap variables) {
        try {
            return DecisionEvaluationUtil.evaluateDecision(decisionDefinition, variables);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while evaluating decision with key '" + this.decisionDefinitionKey + "'", e);
        }
    }

    protected DecisionDefinition getDecisionDefinition(CommandContext commandContext) {
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        if (this.decisionDefinitionId != null) {
            return this.findById(deploymentCache);
        }
        return this.findByKey(deploymentCache);
    }

    protected DecisionDefinition findById(DeploymentCache deploymentCache) {
        return deploymentCache.findDeployedDecisionDefinitionById(this.decisionDefinitionId);
    }

    protected DecisionDefinition findByKey(DeploymentCache deploymentCache) {
        DecisionDefinition decisionDefinition = null;
        if (this.version == null && !this.isTenantIdSet) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKey(this.decisionDefinitionKey);
        } else if (this.version == null && this.isTenantIdSet) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKeyAndTenantId(this.decisionDefinitionKey, this.decisionDefinitionTenantId);
        } else if (this.version != null && !this.isTenantIdSet) {
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyAndVersion(this.decisionDefinitionKey, this.version);
        } else if (this.version != null && this.isTenantIdSet) {
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyVersionAndTenantId(this.decisionDefinitionKey, this.version, this.decisionDefinitionTenantId);
        }
        return decisionDefinition;
    }
}

