/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.dmn.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.repository.DecisionDefinition;
import java.io.Serializable;

public class GetDeploymentDecisionDefinitionCmd
implements Command<DecisionDefinition>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String decisionDefinitionId;

    public GetDeploymentDecisionDefinitionCmd(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @Override
    public DecisionDefinition execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("decisionDefinitionId", (Object)this.decisionDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        DecisionDefinitionEntity decisionDefinition = deploymentCache.findDeployedDecisionDefinitionById(this.decisionDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadDecisionDefinition(decisionDefinition);
        }
        return decisionDefinition;
    }
}

