/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.event;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.bpmn.behavior.ConditionalEventBehavior;
import io.openbpm.bpm.engine.impl.core.variable.event.VariableEvent;
import io.openbpm.bpm.engine.impl.event.EventHandler;
import io.openbpm.bpm.engine.impl.event.EventType;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;

public class ConditionalEventHandler
implements EventHandler {
    @Override
    public String getEventHandlerType() {
        return EventType.CONDITONAL.name();
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, Object localPayload, Object payloadToTriggeredScope, String businessKey, CommandContext commandContext) {
        if (payload != null && !(payload instanceof VariableEvent)) {
            throw new ProcessEngineException("Payload have to be " + VariableEvent.class.getName() + ", to evaluate condition.");
        }
        VariableEvent variableEvent = (VariableEvent)payload;
        ActivityImpl activity = eventSubscription.getActivity();
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        if (!(activityBehavior instanceof ConditionalEventBehavior)) {
            throw new ProcessEngineException("Conditional Event has not correct behavior: " + activityBehavior);
        }
        ConditionalEventBehavior conditionalBehavior = (ConditionalEventBehavior)((Object)activityBehavior);
        conditionalBehavior.leaveOnSatisfiedCondition(eventSubscription, variableEvent);
    }
}

