/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.externaltask;

import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import io.openbpm.bpm.engine.externaltask.FetchAndLockBuilder;
import io.openbpm.bpm.engine.impl.Direction;
import io.openbpm.bpm.engine.impl.ExternalTaskQueryProperty;
import io.openbpm.bpm.engine.impl.QueryOrderingProperty;
import io.openbpm.bpm.engine.impl.externaltask.ExternalTaskQueryTopicBuilderImpl;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class FetchAndLockBuilderImpl
implements FetchAndLockBuilder {
    protected final CommandExecutor commandExecutor;
    protected String workerId;
    protected int maxTasks;
    protected boolean usePriority;
    protected List<QueryOrderingProperty> orderingProperties = new ArrayList<QueryOrderingProperty>();

    public FetchAndLockBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public FetchAndLockBuilderImpl workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl maxTasks(int maxTasks) {
        this.maxTasks = maxTasks;
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl usePriority(boolean usePriority) {
        this.usePriority = usePriority;
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl orderByCreateTime() {
        this.orderingProperties.add(new QueryOrderingProperty(ExternalTaskQueryProperty.CREATE_TIME, null));
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl asc() throws NotValidException {
        this.configureLastOrderingPropertyDirection(Direction.ASCENDING);
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl desc() throws NotValidException {
        this.configureLastOrderingPropertyDirection(Direction.DESCENDING);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder subscribe() {
        this.checkQueryOk();
        return new ExternalTaskQueryTopicBuilderImpl(this.commandExecutor, this.workerId, this.maxTasks, this.usePriority, this.orderingProperties);
    }

    protected void configureLastOrderingPropertyDirection(Direction direction) {
        QueryOrderingProperty lastProperty = this.orderingProperties.isEmpty() ? null : (QueryOrderingProperty)CollectionUtil.getLastElement(this.orderingProperties);
        EnsureUtil.ensureNotNull(NotValidException.class, "You should call any of the orderBy methods first before specifying a direction", "currentOrderingProperty", (Object)lastProperty);
        if (lastProperty.getDirection() != null) {
            EnsureUtil.ensureNull(NotValidException.class, "Invalid query: can specify only one direction desc() or asc() for an ordering constraint", "direction", direction);
        }
        lastProperty.setDirection(direction);
    }

    protected void checkQueryOk() {
        for (QueryOrderingProperty orderingProperty : this.orderingProperties) {
            EnsureUtil.ensureNotNull(NotValidException.class, "Invalid query: call asc() or desc() after using orderByXX()", "direction", (Object)orderingProperty.getDirection());
        }
    }
}

